<?php

namespace App\Http\Controllers\Admin;

use App\DataTables\Admin\LiveTvCategoryDataTable;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\LiveTvCategoryRequest;
use App\Models\LiveTvCategory;
use App\Repositories\Interfaces\Admin\LiveTvCategoryInterface;
use Illuminate\Http\Request;

class LiveTvCategoryController extends Controller
{
    protected $categories;

    public function __construct(LiveTvCategoryInterface $categories) {
        $this->categories = $categories;
    }

    public function index(LiveTvCategoryDataTable $dataTable) {
        return $dataTable->render('admin.live_tv_category.index');
    }

    public function add() {
        return view('admin.live_tv_category.add');
    }

    public function store(LiveTvCategoryRequest $request){
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->categories->store($request->all());
        $data = [
            'status'    => 'success',
            'message'   => __('live_tv_category_added_successfully'),
            'title'     => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }

    public function status(Request $request){
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        LiveTvCategory::where('id', $request->id)->update(['status' => $request->status]);
        $data = [
            'status'    => 'success',
            'message'   => __('live_tv_status_update_successfully'),
            'title'     => __('success'),
            'is_reload' => false,
        ];
        return response()->json($data);
    }

    public function edit($id) {
        $data['category'] = LiveTvCategory::where('id', $id)->first();
        return view('admin.live_tv_category.edit', $data);
    }

    public function update(LiveTvCategoryRequest $request, $id) {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->categories->update($request->all(), $id);
        $data = [
            'status'    => 'success',
            'message'   => __('tv_live_category_update_successfully'),
            'title'     => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }

    public function delete($id) {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        if(!auth()->user()->can('admin.live.tv.delete')){
            $data = [
                'status'    => 'error',
                'message'   => __('you_are_not_authorized_to_perform_this_action'),
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $delete = LiveTvCategory::where('id', $id)->delete();
        if($delete) {
            $data = [
                'title'  => __('Success'),
                'status'  => true,
                'message' => __('tv_live_category_delete_successfully'),
                'is_reload' => true,
            ];
            return $data;
        }
        return false;
    }
}
