<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Config;
use App\Models\Movie;
use App\Models\MovieLanguage;
use App\Models\TvShow;
use App\Repositories\Interfaces\Admin\ImporterInterface;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class ImportController extends Controller
{
    protected $importer;

    public function __construct(ImporterInterface $importer)
    {
        $this->importer = $importer;
    }

    public function index()
    {
        $page_data['movie_tmdb_ids'] = Movie::pluck('tmdb_id');
        $page_data['tv_show_tmdb_ids'] = TvShow::pluck('tmdb_id')->toArray();
        $page_data['movie_languages'] = MovieLanguage::get();
        return view('admin.importer.index', $page_data);
    }

    public function fetchMovies(Request $request) {
        $response  = $this->importer->getTMDBData($request->all());
        return response()->json($response);
    }

    public function importDb($language, $type, $id)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        if (!$language || !$type || !$id) {
            $response['message'] = ('Something went wrong, please try again');
            $response['title'] = ('ops..!');
            $response['status'] = 'error';
            return response()->json($response);
        }

        if ($this->importer->importFromTMDB($language, $type, $id)) {
            $response['message'] = ('Imported Successfully');
            $response['title'] = ('Success');
            $response['status'] = 'success';
        } else {
            $response['message'] = ('Something went wrong, please try again');
            $response['title'] = ('ops..!');
            $response['status'] = 'error';
        }

        return response()->json($response);
    }
}
