<?php

namespace App\Http\Controllers\Admin;

use App\DataTables\Admin\GenreDataTable;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\GenreRequest;
use App\Models\Genre;
use App\Repositories\Interfaces\Admin\GenreInterface;
use App\Traits\ImageTrait;
use Illuminate\Http\Request;

class GenreController extends Controller
{
    protected $genres;
    use ImageTrait;

    public function __construct(GenreInterface $genres) {
        $this->genres = $genres;
    }

    public function index(GenreDataTable $dataTable) {
        return $dataTable->render('admin.genre.index');
    }

    public function add() {
        return view('admin.genre.add');
    }

    public function store(GenreRequest $request){
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->genres->store($request->all());
        $data = [
            'status'    => 'success',
            'message'   => __('genre_added_successfully'),
            'title'     => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }

    public function edit($id) {
        $data['genre'] = Genre::where('id', $id)->first();
        return view('admin.genre.edit', $data);
    }

    public function update(GenreRequest $request, $id) {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->genres->update($request->all(), $id);
        $data = [
            'status'    => 'success',
            'message'   => __('genre_update_successfully'),
            'title'     => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }


    public function status(Request $request){
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        Genre::where('id', $request->id)->update(['status' => $request->status]);
        $data = [
            'status'    => 'success',
            'message'   => __('genre_status_update_successfully'),
            'title'     => __('success'),
            'is_reload' => false,
        ];
        return response()->json($data);
    }

    public function featured(Request $request){
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        Genre::where('id', $request->id)->update(['featured' => $request->status]);
        $data = [
            'status'    => 'success',
            'message'   => __('genre_featured_update_successfully'),
            'title'     => __('success'),
            'is_reload' => false,
        ];
        return response()->json($data);
    }

    public function delete($id) {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        if(!auth()->user()->can('admin.genre.delete')){
            $data = [
                'status'    => 'error',
                'message'   => __('you_are_not_authorized_to_perform_this_action'),
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->imageDelete($id, 'genre', 'icon');
        $genreDelete = Genre::where('id', $id)->delete();
        if($genreDelete) {
            $data = [
                'title'  => __('Success'),
                'status'  => true,
                'message' => __('genre_delete_successfully'),
                'is_reload' => true,
            ];
            return $data;
        }
        return false;
    }
}
