<?php

namespace App\Http\Controllers\Admin;

use App\DataTables\Admin\CustomerQueryDataTable;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\CustomerQueryReplyRequest;
use App\Repositories\Interfaces\Admin\CustomerQueryInterface;

class CustomerQueryController extends Controller
{
    protected $queryRepo;

    public function __construct(CustomerQueryInterface $queryRepo)
    {
        $this->queryRepo = $queryRepo;
    }
    public function index(CustomerQueryDataTable $dataTable)
    {
        return $dataTable->render('admin.customer_queries.index');
    }

    public function show($id)
    {
        $query = $this->queryRepo->find($id);
        return view('admin.customer_queries.show', compact('query'));
    }

    public function reply(CustomerQueryReplyRequest $request, $id)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->queryRepo->reply($id, $request->validated()['reply']);
        return redirect()->route('admin.customer_queries.show', $id)->with('success_message', 'Reply sent successfully.');
    }
}
