<?php

namespace App\Http\Controllers\Admin;

use App\DataTables\Admin\CountryDataTable;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\CountryRequest;
use App\Models\Country;
use App\Repositories\Interfaces\Admin\CountryInterface;
use Illuminate\Http\Request;

class CountryController extends Controller
{
    protected $countries;

    public function __construct(CountryInterface $languages) {
        $this->countries = $languages;
    }

    public function index(CountryDataTable $dataTable) {
        return $dataTable->render('admin.country.index');
    }

    public function add() {
        return view('admin.country.add');
    }

    public function store(CountryRequest $request){
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->countries->store($request->all());
        $data = [
            'status'    => 'success',
            'message'   => __('category_added_successfully'),
            'title'     => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }

    public function edit($id) {
        $data['country'] = Country::where('id', $id)->first();
        return view('admin.country.edit', $data);
    }

    public function update(CountryRequest $request, $id) {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->countries->update($request->all(), $id);
        $data = [
            'status'    => 'success',
            'message'   => __('category_update_successfully'),
            'title'     => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }

    public function status(Request $request){
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        Country::where('id', $request->id)->update(['status' => $request->status]);
        $data = [
            'status'    => 'success',
            'message'   => __('country_status_update_successfully'),
            'title'     => __('success'),
            'is_reload' => false,
        ];
        return response()->json($data);
    }

    public function delete($id) {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        if(!auth()->user()->can('admin.country.edit')){
            $data = [
                'status'    => 'error',
                'message'   => __('you_are_not_authorized_to_perform_this_action'),
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $countryDelete = Country::where('id', $id)->delete();
        if($countryDelete) {
            $data = [
                'title'  => __('Success'),
                'status'  => true,
                'message' => __('country_delete_successfully'),
                'is_reload' => true,
            ];
            return $data;
        }
        return false;
    }
}
