<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Config;
use App\Models\Currency;
use App\Models\Language;
use App\Models\MovieLanguage;
use App\Models\Timezone;
use App\Repositories\Interfaces\Admin\SettingInterface;
use App\Traits\ImageTrait;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class ConfigController extends Controller
{
    use ImageTrait;

    protected $setting;

    public function __construct(SettingInterface $setting)
    {
        $this->setting = $setting;
    }

    public function systemSettings()
    {
        $page_data['timezones'] = Timezone::get();
        $page_data['currencies'] = Currency::get();
        $page_data['system_languages'] = Language::where('status', 1)->get();
        return view('admin.settings.system_settings', $page_data);
    }
    public function adminSettings()
    {
        return view('admin.settings.admin_settings');
    }
    public function recaptchaSettings()
    {
        return view('admin.settings.recaptcha_settings');
    }
    public function tmdbSettings()
    {
        $page_data['movie_languages'] = MovieLanguage::get();

        return view('admin.settings.tmdb_settings', $page_data);
    }
    public function socialSettings()
    {
        return view('admin.settings.social_settings');
    }
    public function settingUpdate(Request $request, $type = null)
    {
        if (isDemoMode()) {
            return redirect()->back()->with('toastr_error', 'This action is disabled in demo mode.');
        }
        Session::put('tab_type', $type);
        try {
            $timestamp = Carbon::now();
            foreach ($request->all() as $key => $value) {
                if ($key == '_token') {
                    continue;
                }
                if ($request->hasFile($key)) {
                    // Delete old image if exists
                    if (!blank(get_config($key))) {
                        //dd(get_config($key));
                        $this->deleteImage(json_decode(get_config($key), true));
                    }
                    // Save the new image
                    $response = $this->saveImage($request->file($key), $key);
                    $value = json_encode($response['images']);
                }
                Config::updateOrCreate(
                    ['title' => $key],
                    [
                        'value' => $value,
                        'updated_at' => $timestamp,
                        'created_at' => Config::where('title', $key)->exists() ? Config::where('title', $key)->value('created_at') : $timestamp
                    ]
                );
            }
            return redirect()->back()->with('toastr_success', __('setting_updated_successfully'));
        } catch (\Exception $e) {
            Log::error('Error updating settings: ' . $e->getMessage());
            return redirect()->back()->with('toastr_error', __('setting_updated_failled'));
        }
    }

    public function smsGatewaySettings()
    {
        return view('admin.settings.sms_gateway');
    }

    public function systemStatus(Request $request)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        try {

            $data = $this->setting->systemStatus($request);

            return response()->json($data);
        } catch (\Exception $e) {
            $data = [
                'status'    => 'error',
                'message'   => __('setting_updated_failled'),
                'title'     => __('error'),
                'is_reload' => true,
            ];

            return response()->json($data);
        }
    }
}
