<?php

namespace App\Http\Controllers\Admin;

use App\DataTables\Admin\BlogDataTable;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\BlogRequest;
use App\Models\Blog;
use App\Models\BlogCategory;
use App\Repositories\Interfaces\Admin\BlogInterface;
use App\Traits\ImageTrait;
use Illuminate\Http\Request;

class BlogController extends Controller
{
    protected $blogs;
    use ImageTrait;

    public function __construct(BlogInterface $blogs)
    {
        $this->blogs = $blogs;
    }

    public function index(BlogDataTable $dataTable)
    {
        return $dataTable->render('admin.blog.index');
    }

    public function add()
    {
        $page_data['categories'] = BlogCategory::where('status', 1)->get();
        return view('admin.blog.add', $page_data);
    }
    public function edit($id)
    {
        $page_data['categories'] = BlogCategory::where('status', 1)->get();
        $page_data['blog'] = Blog::where('id', $id)->first();
        return view('admin.blog.edit', $page_data);
    }

    public function store(BlogRequest $request)
    {
        if (isDemoMode()) {
            session()->flash('toastr_error', 'This action is disabled in demo mode.!');
            return redirect()->route('admin.blogs');
        }
        $this->blogs->store($request->all());
        session()->flash('toastr_success', 'blog_create_successful!');
        return redirect()->route('admin.blogs');
    }
    public function update(BlogRequest $request, $id)
    {
        if (isDemoMode()) {
            session()->flash('toastr_error', 'This action is disabled in demo mode.!');
            return redirect()->route('admin.blogs');
        }
        $this->blogs->update($request->all(), $id);
        session()->flash('toastr_success', 'blog_create_successful!');
        return redirect()->route('admin.blogs');
    }

    public function status(Request $request)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        Blog::where('id', $request->id)->update(['status' => $request->status]);
        $data = [
            'status' => 'success',
            'message' => __('blog_status_update_successfully'),
            'title' => __('success'),
            'is_reload' => false,
        ];
        return response()->json($data);
    }

    public function delete($id)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        if(!auth()->user()->can('admin.blog.delete')){
            $data = [
                'status'    => 'error',
                'message'   => __('you_are_not_authorized_to_perform_this_action'),
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->imageDelete($id, 'blog', 'image');
        $blogDelete = Blog::where('id', $id)->delete();
        if ($blogDelete) {
            $data = [
                'title' => __('Success'),
                'status' => true,
                'message' => __('blog_delete_successfully'),
                'is_reload' => true,
            ];
            return $data;
        }
        return false;
    }

}
