<?php

namespace App\Http\Controllers\Admin;

use App\DataTables\Admin\BlogCategoryDataTable;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\BlogCategoryRequest;
use App\Models\BlogCategory;
use App\Repositories\Interfaces\Admin\BlogCategoryInterface;
use Illuminate\Http\Request;

class BlogCategoryController extends Controller
{
    protected $categories;

    public function __construct(BlogCategoryInterface $categories)
    {
        $this->categories = $categories;
    }

    public function index(BlogCategoryDataTable $dataTable)
    {
        return $dataTable->render('admin.blog_category.index');
    }

    public function add()
    {
        $page_data['categories'] = BlogCategory::where('status', 1)->get();
        return view('admin.blog_category.add', $page_data);
    }

    public function store(BlogCategoryRequest $request)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->categories->store($request->all());
        $data = [
            'status' => 'success',
            'message' => __('category_added_successfully'),
            'title' => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }

    public function status(Request $request)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        BlogCategory::where('id', $request->id)->update(['status' => $request->status]);
        $data = [
            'status' => 'success',
            'message' => __('blog_category_status_update_successfully'),
            'title' => __('success'),
            'is_reload' => false,
        ];
        return response()->json($data);
    }

    public function edit($id)
    {
        $page_data['category'] = BlogCategory::where('id', $id)->first();
        $page_data['categories'] = BlogCategory::where('status', 1)->get();
        return view('admin.blog_category.edit', $page_data);
    }

    public function update(BlogCategoryRequest $request, $id)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->categories->update($request->all(), $id);
        $data = [
            'status' => 'success',
            'message' => __('category_update_successfully'),
            'title' => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }

    public function delete($id)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        if(!auth()->user()->can('admin.blog.category.delete')){
            $data = [
                'status'    => 'error',
                'message'   => __('you_are_not_authorized_to_perform_this_action'),
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $categoryDelete = BlogCategory::where('id', $id)->delete();
        if ($categoryDelete) {
            $data = [
                'title' => __('Success'),
                'status' => true,
                'message' => __('category_delete_successfully'),
                'is_reload' => true,
            ];
            return $data;
        }
        return false;
    }
}
