<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Traits\AiTrait;
use Illuminate\Http\Request;

class AiController extends Controller
{
    use AiTrait;
    public function content_generate(Request $request)
    {
        if (isDemoMode()) {
            return response()->json(['content' => 'This action is disabled in demo mode.']);
        }

        if (!$request->has('type')) {
            return response()->json(['content' => 'Type parameter is required'], 400);
        }

        if ($request->type === 'movie_description') {
            
            // Call the method from the AiTrait to generate movie description
            $description = $this->generateMovieDescription($request->all());
            return response()->json(['content' => $description]);

        } elseif ($request->type === 'movie_meta_description') {

            $description = $this->generateMovieMetaDescription($request->all());
            return response()->json(['content' => $description]);
            
        } elseif ($request->type === 'tv_series_description') {

            $description = $this->generateTvSeriesDescription($request->all());
            return response()->json(['content' => $description]);

        } elseif ($request->type === 'tv_series_meta_description') {

            $description = $this->generateTvSeriesMetaDescription($request->all());
            return response()->json(['content' => $description]);

        } elseif ($request->type === 'live_tv_description') {

            $description = $this->generateLiveTvDescription($request->all());
            return response()->json(['content' => $description]);

        } elseif ($request->type === 'live_tv_meta_description') {

            $description = $this->generateLiveTvMetaDescription($request->all());
            return response()->json(['content' => $description]);

        } elseif ($request->type === 'blog_description') {

            $description = $this->generateBlogDescription($request->all());
            return response()->json(['content' => $description]);

        } elseif ($request->type === 'blog_meta_description') {

            $description = $this->generateBlogMetaDescription($request->all());
            return response()->json(['content' => $description]);

        } else {
            return response()->json(['content' => 'Invalid type parameter'], 400);
        }
    
    }
}
