<?php

namespace App\Http\Controllers\Admin;

use App\DataTables\Admin\AdsDataTable;
use App\DataTables\Admin\MidRollAdsDataTable;
use App\DataTables\Admin\PostRollAdsDataTable;
use App\DataTables\Admin\PreRollAdsDataTable;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\AdsRequest;
use App\Http\Requests\Admin\MidRollRequest;
use App\Models\Ads;
use App\Repositories\Interfaces\Admin\AdsInterface;
use App\Traits\ImageTrait;
use Illuminate\Http\Request;

class AdsController extends Controller
{
    protected $Ads;
    use ImageTrait;

    public function __construct(AdsInterface $Ads)
    {
        $this->Ads = $Ads;
    }

    public function index(AdsDataTable $dataTable)
    {
        return $dataTable->render('admin.ads.index');
    }

    public function preRollIndex(PreRollAdsDataTable $dataTable)
    {
        return $dataTable->render('admin.ads.pre_roll.index');
    }

    // This is the pre-roll ads section
    // The following methods are for managing pre-roll ads
    public function preRollAdd()
    {
        $page_data = [
            'page_title' => __('manage_pre_roll_ads')
        ];
        return view('admin.ads.pre_roll.add', $page_data);
    }
    /**
     * Store pre-roll ads
     *
     * @param AdsRequest $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function preRollStore(AdsRequest $request)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->Ads->store($request->all(), 'pre_roll');
        $data = [
            'status'    => 'success',
            'message'   => __('pre_roll_ads_added_successfully'),
            'title'     => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }
    public function preRollEdit($id)
    {
        $data['ad'] = Ads::where('id', $id)->first();
        return view('admin.ads.pre_roll.edit', $data);
    }

    public function preRollUpdate(AdsRequest $request, $id)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->Ads->update($request->all(), $id, 'pre_roll');
        $data = [
            'status'    => 'success',
            'message'   => __('pre_roll_ads_update_successfully'),
            'title'     => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }

    // This is the mid-roll ads section
    // The following methods are for managing mid-roll ads
    public function midRollIndex(MidRollAdsDataTable $dataTable)
    {
        return $dataTable->render('admin.ads.mid_roll.index');
    }

    public function midRollAdd()
    {
        $page_data = [
            'page_title' => __('manage_mid_roll_ads')
        ];
        return view('admin.ads.mid_roll.add', $page_data);
    }

    public function midRollStore(MidRollRequest $request)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->Ads->store($request->all(), 'mid_roll');
        $data = [
            'status'    => 'success',
            'message'   => __('mid_roll_ads_added_successfully'),
            'title'     => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }

    public function midRollEdit($id)
    {
        $data['ad'] = Ads::where('id', $id)->first();
        return view('admin.ads.mid_roll.edit', $data);
    }

    public function midRollUpdate(MidRollRequest $request, $id)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->Ads->update($request->all(), $id, 'mid_roll');
        $data = [
            'status'    => 'success',
            'message'   => __('mid_roll_ads_update_successfully'),
            'title'     => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }

    // This is the post-roll ads section
    // The following methods are for managing post-roll ads
    public function postRollIndex(PostRollAdsDataTable $dataTable)
    {
        return $dataTable->render('admin.ads.post_roll.index');
    }

    public function postRollAdd()
    {
        $page_data = [
            'page_title' => __('manage_post_roll_ads')
        ];
        return view('admin.ads.post_roll.add', $page_data);
    }
    public function postRollStore(AdsRequest $request)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->Ads->store($request->all(), 'post_roll');
        $data = [
            'status'    => 'success',
            'message'   => __('post_roll_ads_added_successfully'),
            'title'     => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }
    public function postRollEdit($id)
    {
        $data['ad'] = Ads::where('id', $id)->first();
        return view('admin.ads.post_roll.edit', $data);
    }

    public function postRollUpdate(AdsRequest $request, $id)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->Ads->update($request->all(), $id, 'post_roll');
        $data = [
            'status'    => 'success',
            'message'   => __('post_roll_ads_update_successfully'),
            'title'     => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }

    public function edit($id)
    {
        $data['ads'] = Ads::where('id', $id)->first();
        return view('admin.ads.edit', $data);
    }

    public function update(AdsRequest $request, $id)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->Ads->update($request->all(), $id);
        $data = [
            'status'    => 'success',
            'message'   => __('ads_update_successfully'),
            'title'     => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }

    public function status(Request $request)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        Ads::where('id', $request->id)->update(['status' => $request->status]);
        $data = [
            'status'    => 'success',
            'message'   => __('ads_status_update_successfully'),
            'title'     => __('success'),
            'is_reload' => false,
        ];
        return response()->json($data);
    }

    public function delete($id)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }

        if(!auth()->user()->can('admin.ads.delete')){
            $data = [
                'status'    => 'error',
                'message'   => __('you_are_not_authorized_to_perform_this_action'),
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        
        $this->imageDelete($id, 'ads', 'banner');
        $faqDelete = Ads::where('id', $id)->delete();
        if ($faqDelete) {
            $data = [
                'title'  => __('Success'),
                'status'  => true,
                'message' => __('ads_delete_successfully'),
                'is_reload' => true,
            ];
            return $data;
        }
        return false;
    }
}
