<?php

namespace App\DataTables\Admin;

use App\Models\TvShow;
use Illuminate\Database\Eloquent\Builder as QueryBuilder;
use Yajra\DataTables\Html\Builder as HtmlBuilder;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Services\DataTable;
use Yajra\DataTables\EloquentDataTable;

class TvShowDataTable extends DataTable
{public function dataTable(QueryBuilder $query): EloquentDataTable
    {
        return (new EloquentDataTable($query))
            ->addIndexColumn()
            ->addColumn('thumbnail', function ($show) {
                return view('admin.tv_show.image', compact('show'));
            })
            ->addColumn('title', function ($show) {
                return $show->title;
            })
            ->addColumn('description', function ($show) {
                return substr_replace(strip_tags($show->description), '...', 200);
            })
            ->addColumn('video_type', function ($show) {
                return $show->type?->video_type ?? __('Imported');
            })
            ->addColumn('video_quality', function ($show) {
                return $movie->quality?->quality ?? __('full_hd');
            })
            
            ->addColumn('status', function ($show) {
                return $show->status == 1 ? __('publish'):__('hidden');
            })
            ->addColumn('option', function ($show) {
                return view('admin.tv_show.action', compact('show'));
            })
            ->setRowId('id');
    }

	public function query(): QueryBuilder
	{
        return TvShow::when($this->request->search['value'] ?? false, function ($query) {
            $search = $this->request->search['value'];
            $query->where('title', 'like', "%$search%")
                ->orWhere('slug', 'like', "%$search%");
        })
        ->latest()
        ->newQuery();
	}

	public function html(): HtmlBuilder
    {
        return $this->builder()
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->orderBy(1)
            ->selectStyleSingle()
            ->setTableAttribute('style', 'width:99.8%')
            ->footerCallback('function ( row, data, start, end, display ) {

                $(".dataTables_length select").addClass("form-select form-select-lg without_search mb-3");
                selectionFields();
            }')
            ->parameters([
                'dom'        => 'Blfrtip',
                'buttons'    => [
                    [],
                ],
                'lengthMenu' => [[10, 25, 50, 100, 250], [10, 25, 50, 100, 250]],
                'language'   => [
                    'searchPlaceholder' => __('search'),
                    'lengthMenu'        => '_MENU_ '.__('tv_show_per_page'),
                    'search'            => '',
                ],
            ]);
    }

    public function getColumns(): array
    {
        return [
			Column::computed('id')->data('DT_RowIndex')->title('#')->searchable(false)->width(10),
            Column::computed('thumbnail')->title(__('thumbnail')),
            Column::computed('title')->title(__('title')),
            Column::computed('description')->title(__('description')),
            Column::computed('video_type')->title(__('video_type')),
            Column::computed('video_quality')->title(__('video_quality')),
            Column::computed('status')->title(__('status')),
            Column::computed('option')->title(__('option')),
           
        ];
    }

    protected function filename(): string
    {
        return 'Currency_'.date('YmdHis');
    }


}