<?php

namespace App\DataTables\Admin;

use App\Models\Star;
use Illuminate\Database\Eloquent\Builder as QueryBuilder;
use Yajra\DataTables\Html\Builder as HtmlBuilder;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Services\DataTable;
use Yajra\DataTables\EloquentDataTable;

class StarDataTable extends DataTable
{public function dataTable(QueryBuilder $query): EloquentDataTable
    {
        return (new EloquentDataTable($query))
            ->addIndexColumn()
            ->addColumn('star_image', function ($star) {
                return view('admin.star.image', compact('star'));
            })
            ->addColumn('star_name', function ($star) {
                return $star->star_name;
            })
            ->addColumn('star_desc', function ($star) {
                return $star->star_desc;
            })
            ->addColumn('star_type', function ($star) {
                return $star->star_type;
            })
            ->addColumn('status', function ($star) {
                return view('admin.star.status', compact('star'));
            })
            ->addColumn('option', function ($star) {
                return view('admin.star.action', compact('star'));
            })
            ->setRowId('id');
    }

	public function query(): QueryBuilder
	{
        return Star::when($this->request->search['value'] ?? false, function ($query) {
            $search = $this->request->search['value'];
            $query->where('star_name', 'like', "%$search%");
        })
        ->latest()
        ->newQuery();
	}

	public function html(): HtmlBuilder
    {
        return $this->builder()
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->orderBy(1)
            ->selectStyleSingle()
            ->setTableAttribute('style', 'width:99.8%')
            ->footerCallback('function ( row, data, start, end, display ) {

                $(".dataTables_length select").addClass("form-select form-select-lg without_search mb-3");
                selectionFields();
            }')
            ->parameters([
                'dom'        => 'Blfrtip',
                'buttons'    => [
                    [],
                ],
                'lengthMenu' => [[10, 25, 50, 100, 250], [10, 25, 50, 100, 250]],
                'language'   => [
                    'searchPlaceholder' => __('search'),
                    'lengthMenu'        => '_MENU_ '.__('star_per_page'),
                    'search'            => '',
                ],
            ]);
    }

    public function getColumns(): array
    {
        return [
			Column::computed('id')->data('DT_RowIndex')->title('#')->searchable(false)->width(10),
            Column::computed('star_image')->title(__('star_image')),
            Column::computed('star_name')->title(__('star_name')),
            Column::computed('star_desc')->title(__('star_desc')),
            Column::computed('star_type')->title(__('star_type')),
            Column::computed('status')->title(__('status')),
            Column::computed('option')->title(__('option')),
           
        ];
    }

    protected function filename(): string
    {
        return 'Currency_'.date('YmdHis');
    }


}