<?php

namespace App\DataTables\Admin;

use App\Models\Movie;
use Illuminate\Database\Eloquent\Builder as QueryBuilder;
use Yajra\DataTables\Html\Builder as HtmlBuilder;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Services\DataTable;
use Yajra\DataTables\EloquentDataTable;

class MovieLinkDataTable extends DataTable
{public function dataTable(QueryBuilder $query): EloquentDataTable
    {
        return (new EloquentDataTable($query))
            ->addIndexColumn()
            ->addColumn('link_title', function ($download) {
                return $download->link_title;
            })
            ->addColumn('resolution', function ($download) {
                return $download->resolution;
            })
            ->addColumn('file_size', function ($download) {
                return $download->file_size;
            })
            ->addColumn('download_url', function ($download) {
                return $download->download_url;
            })
            ->addColumn('option', function ($download) {
                return view('admin.tv_show.download.action', compact('download'));
            })
            ->setRowId('id');
    }

	public function query(): QueryBuilder
	{
        return Movie::where('season_id', $this->season_id)->when($this->request->search['value'] ?? false, function ($query) {
            $search = $this->request->search['value'];
            $query->where('link_title', 'like', "%$search%");
        })
        ->latest()
        ->newQuery();
	}

	public function html(): HtmlBuilder
    {
        return $this->builder()
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->orderBy(1)
            ->selectStyleSingle()
            ->setTableAttribute('style', 'width:99.8%')
            ->footerCallback('function ( row, data, start, end, display ) {

                $(".dataTables_length select").addClass("form-select form-select-lg without_search mb-3");
                selectionFields();
            }')
            ->parameters([
                'dom'        => 'Blfrtip',
                'buttons'    => [
                    [],
                ],
                'lengthMenu' => [[10, 25, 50, 100, 250], [10, 25, 50, 100, 250]],
                'language'   => [
                    'searchPlaceholder' => __('search'),
                    'lengthMenu'        => '_MENU_ '.__('movie_link_per_page'),
                    'search'            => '',
                ],
            ]);
    }

    public function getColumns(): array
    {
        return [
			Column::computed('id')->data('DT_RowIndex')->title('#')->searchable(false)->width(10),
            Column::computed('link_title')->title(__('link_title')),
            Column::computed('resolution')->title(__('resolution')),
            Column::computed('file_size')->title(__('file_size')),
            Column::computed('download_url')->title(__('download_url')),
            Column::computed('option')->title(__('option')),
           
        ];
    }

    protected function filename(): string
    {
        return 'Currency_'.date('YmdHis');
    }


}