<?php

namespace App\DataTables\Admin;

use App\Models\LiveTv;
use Illuminate\Database\Eloquent\Builder as QueryBuilder;
use Yajra\DataTables\Html\Builder as HtmlBuilder;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Services\DataTable;
use Yajra\DataTables\EloquentDataTable;

class LiveTvDataTable extends DataTable
{public function dataTable(QueryBuilder $query): EloquentDataTable
    {
        return (new EloquentDataTable($query))
            ->addIndexColumn()
            ->addColumn('thumbnail', function ($live_tv) {
                return view('admin.live_tv.image', compact('live_tv'));
            })
            ->addColumn('tv_name', function ($live_tv) {
                return $live_tv->tv_name;
            })
            ->addColumn('stream_url', function ($live_tv) {
                return $live_tv->stream_url;
            })
            ->addColumn('category', function ($live_tv) {
                return $live_tv->category->live_tv_category;
            })
            ->addColumn('status', function ($live_tv) {
                return view('admin.live_tv.status', compact('live_tv'));
            })
            ->addColumn('option', function ($live_tv) {
                return view('admin.live_tv.action', compact('live_tv'));
            })
            ->setRowId('id');
    }

	public function query(): QueryBuilder
	{
        return LiveTv::when($this->request->search['value'] ?? false, function ($query) {
            $search = $this->request->search['value'];
            $query->where('tv_name', 'like', "%$search%");
        })
        ->latest()
        ->newQuery();
	}

	public function html(): HtmlBuilder
    {
        return $this->builder()
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->orderBy(1)
            ->selectStyleSingle()
            ->setTableAttribute('style', 'width:99.8%')
            ->footerCallback('function ( row, data, start, end, display ) {

                $(".dataTables_length select").addClass("form-select form-select-lg without_search mb-3");
                selectionFields();
            }')
            ->parameters([
                'dom'        => 'Blfrtip',
                'buttons'    => [
                    [],
                ],
                'lengthMenu' => [[10, 25, 50, 100, 250], [10, 25, 50, 100, 250]],
                'language'   => [
                    'searchPlaceholder' => __('search'),
                    'lengthMenu'        => '_MENU_ '.__('live_tv_per_page'),
                    'search'            => '',
                ],
            ]);
    }

    public function getColumns(): array
    {
        return [
			Column::computed('id')->data('DT_RowIndex')->title('#')->width(10),
            Column::computed('thumbnail')->title(__('thumbnail')),
            Column::computed('tv_name')->title(__('tv_name')),
            Column::computed('stream_url')->title(__('stream_url')),
            Column::computed('category')->title(__('live_tv_category_id')),
            Column::computed('status')->title(__('status')),
            Column::computed('option')->title(__('option')),
           
        ];
    }

    protected function filename(): string
    {
        return 'Currency_'.date('YmdHis');
    }


}