<?php

namespace App\DataTables\Admin;

use App\Models\Faq;
use Illuminate\Database\Eloquent\Builder as QueryBuilder;
use Yajra\DataTables\Html\Builder as HtmlBuilder;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Services\DataTable;
use Yajra\DataTables\EloquentDataTable;

class FaqDataTable extends DataTable
{public function dataTable(QueryBuilder $query): EloquentDataTable
    {
        return (new EloquentDataTable($query))
            ->addIndexColumn()
            ->addColumn('question', function ($faq) {
                return $faq->question;
            })
            ->addColumn('answer', function ($faq) {
                return $faq->answer;
            })
            ->addColumn('type', function ($faq) {
                return $faq->type == 'order' ? __('order_&_return') : __('purchase_&_payment');
            })
            ->addColumn('status', function ($faq) {
                return view('admin.faq.status', compact('faq'));
            })
            ->addColumn('option', function ($faq) {
                return view('admin.faq.action', compact('faq'));
            })
            ->setRowId('id');
    }

	public function query(): QueryBuilder
	{
		$search = request('search.value');
        return Faq::when($this->request->search['value'] ?? false, function ($query) {
            $search = $this->request->search['value'];
            $query->where('question', 'like', "%$search%");
        })
        ->latest()
        ->newQuery();
	}

	public function html(): HtmlBuilder
    {
        return $this->builder()
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->orderBy(1)
            ->selectStyleSingle()
            ->setTableAttribute('style', 'width:99.8%')
            ->footerCallback('function ( row, data, start, end, display ) {

                $(".dataTables_length select").addClass("form-select form-select-lg without_search mb-3");
                selectionFields();
            }')
            ->parameters([
                'dom'        => 'Blfrtip',
                'buttons'    => [
                    [],
                ],
                'lengthMenu' => [[10, 25, 50, 100, 250], [10, 25, 50, 100, 250]],
                'language'   => [
                    'searchPlaceholder' => __('search'),
                    'lengthMenu'        => '_MENU_ '.__('faq_per_page'),
                    'search'            => '',
                ],
            ]);
    }

    public function getColumns(): array
    {
        return [
			Column::computed('id')->data('DT_RowIndex')->title('#')->width(10),
            Column::computed('question')->title(__('question')),
            Column::computed('answer')->title(__('answer')),
            Column::computed('type')->title(__('type')),
            Column::computed('status')->title(__('status')),
            Column::computed('option')->title(__('option')),
           
        ];
    }

    protected function filename(): string
    {
        return 'Currency_'.date('YmdHis');
    }


}